using System;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
using Microsoft.ContentManagement.WebControls.Design;
using Microsoft.ContentManagement.WebControls;

namespace UKIB.WindowsMediaPlayerControlLibrary
{
	/// <summary>
	/// This source code is freeware and is provided on an as is basis without
	/// warranties of any kind, whether express or implied, including without
	/// limitation warranties that the code is free of defect, fit for a
	/// particular purpose or non-infringing.  The entire risk as to the quality
	/// and performance of the code is with the end user.
	/// 
	/// This is a placeholder control for Windows Media Player content.
	/// </summary>
	
	public enum uimodes {none,mini,full};

	[
	ToolboxData("<{0}:WindowsMediaPlayerControl runat=server></{0}:WindowsMediaPlayerControl>"), 
	SupportedPlaceholderDefinitionType(typeof(AttachmentPlaceholderDefinition))
	]
	
	

	public class WindowsMediaPlayerControl : SingleAttachmentPlaceholderControl
	{
		private LiteralControl wmpPresentationControl;
		private int wmpWidth;
		private int wmpHeight;
		private bool mustUseTemplateDefinedSize;
		private bool wmpAutostart;
		private int wmpBalance;
		private bool wmpEnableContextMenu;
		private bool wmpStretchToFit;
		private uimodes wmpUIMode;

		// Width of the WMP Control
		[
		Browsable(true),
		Description("Width of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue(400)
		]
		public int WmpWidth
		{
			get
			{
				return this.wmpWidth;
			}
			set
			{
				this.wmpWidth = value;
			}
		}

		// Height of the wmp Control
		[
		Browsable(true),
		Description("Height of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue(300)
		]
		public int WmpHeight
		{
			get
			{
				return this.wmpHeight;
			}
			set
			{
				this.wmpHeight = value;
			}
		}

		// Allow height and width settings to be overriden locally ?
		[
		Browsable(true),
		Description("Allow/Disallow size override with local settings"),
		Category("Data"),
		DefaultValue(false)
		]
		public bool MustUseTemplateDefinedSize
		{
			get
			{
				return this.mustUseTemplateDefinedSize;
			}
			set
			{
				this.mustUseTemplateDefinedSize = value;
			}
		}

		// Autostart parameter of the wmp Control
		[
		Browsable(true),
		Description("Autostart parameter of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue(true)
		]
		public bool WmpAutostart
		{
			get
			{
				return this.wmpAutostart;
			}
			set
			{
				this.wmpAutostart = value;
			}
		}

		// Balance parameter of the wmp Control
		[
		Browsable(true),
		Description("Balance parmeter of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue(0)
		]
		public int WmpBalance
		{
			get
			{
				return this.wmpBalance;
			}
			set
			{
				this.wmpBalance = value;
			}
		}

		// enableContextMenu parameter of the wmp Control
		[
		Browsable(true),
		Description("enableContextMenu parmeter of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue(false)
		]
		public bool WmpEnableContextMenu
		{
			get
			{
				return this.wmpEnableContextMenu;
			}
			set
			{
				this.wmpEnableContextMenu = value;
			}
		}

		// stretchToFit parameter of the wmp Control
		[
		Browsable(true),
		Description("stretchToFit parmeter of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue(true)
		]
		public bool WmpStretchToFit
		{
			get
			{
				return this.wmpStretchToFit;
			}
			set
			{
				this.wmpStretchToFit = value;
			}
		}

		// uiMode parameter of the wmp Control
		[
		Browsable(true),
		Description("uiMode parmeter of the WindowsMediaPlayerPlaceholderControl"),
		Category("Data"),
		DefaultValue("mini")
		]
		public uimodes WmpUIMode
		{
			get
			{
				return this.wmpUIMode;
			}
			set
			{
				this.wmpUIMode = value;
			}
		}

		public WindowsMediaPlayerControl()
		{
			//
			// Constructor - here the default height and width is defined
			//
			wmpHeight = 300;
			wmpWidth = 400;
			mustUseTemplateDefinedSize = false;
			wmpAutostart = true;
			wmpBalance = 0;
			wmpEnableContextMenu = false;
			wmpStretchToFit = true;
			wmpUIMode = uimodes.mini;
			
		}

		// This Placeholder is based on an AttachmentPlaceholder that holds the link to the Windows Media
		private AttachmentPlaceholder BoundAttachmentPlaceholder
		{
			get
			{
				return (AttachmentPlaceholder)this.BoundPlaceholder;
			}
		}

		// HtmlOutput in Presentation Mode is written to a LiteralControl
		protected override void CreatePresentationChildControls(BaseModeContainer presentationContainer)
		{
			this.wmpPresentationControl = new LiteralControl();
			this.wmpPresentationControl.ID = "WMPPresentationControl";
			presentationContainer.Controls.Add(this.wmpPresentationControl);
		}

		// We just need to modify the Presentation Mode. 
		// Authoring Mode is still a standard AttachmentPlaceholderControl
		// Here the Html Code for embedding the WMP Object is defined
		protected override void LoadPlaceholderContentForPresentation(PlaceholderControlEventArgs e) 
		{
			EnsureChildControls();
			try 
			{
				String Url = this.BoundAttachmentPlaceholder.Url;
				if (Url == "")
					this.wmpPresentationControl.Text = "";
				else
				{
					if ((this.mustUseTemplateDefinedSize == false) &
						(this.BoundAttachmentPlaceholder.AttachmentText[0] == '(') &
						(this.BoundAttachmentPlaceholder.AttachmentText.IndexOf(",") > 0) &
						(this.BoundAttachmentPlaceholder.AttachmentText.IndexOf(")") > 0))
					{
						String str = BoundAttachmentPlaceholder.AttachmentText;
						wmpWidth = int.Parse(str.Substring(1,str.IndexOf(",")-1));
						wmpHeight = int.Parse(str.Substring(str.IndexOf(",")+1,str.IndexOf(")")-str.IndexOf(",")-1));
					}
					this.wmpPresentationControl.Text = 
						"<object ID=\"player\" classid=\"CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6\" "+
						"width="+wmpWidth+" height="+wmpHeight+"> "+
						"<param name=\"url\" value=\""+Url+"\"> "+
						"<param name=\"autostart\" value=\""+wmpAutostart+"\"> "+
						"<param name=\"balance\" value=\""+wmpBalance+"\"> "+
						"<param name=\"enableContextMenu\" value=\""+wmpEnableContextMenu+"\"> "+
						"<param name=\"stretchToFit\" value=\""+wmpStretchToFit+"\"> "+
						"<param name=\"uiMode\" value=\""+wmpUIMode.ToString()+"\"> "+
						"</object>";
				}
			}
			catch (Exception exp) 
			{
				// show the error as placeholder content
				this.wmpPresentationControl.Text = "<error>" + exp.Message + "</error>";
			}
		}
	}
}
